using McCormick, BenchmarkTools

"""
Direct relaxation of implicit function
"""
function direct_relax(f, x, p)
    delta = Inf
    while delta > 1e-8
        x_prev = x
        x = f(x, p)
        delta = abs(x_prev.cv - x.cv) + abs(x_prev.cc - x.cc)
    end

    return x
end

"""
Faster alternative
"""
function fast_direct_relax(f, x, p)
    delta = Inf
    while delta > 1e-8
        x_prev = x
        x_m = x.cv + .5 * (x.cc - x.cv)
        x = f(x_m, p)
        delta = abs(x_prev.cv - x.cv) + abs(x_prev.cc - x.cc)
    end

    return x
end

f(x, p) = (p - (p^3)/6 + (p^5)/120)*x^(-1/2) + 100

p = MC{1,NS}(1.0, 1.0, Interval(0.5, 5.0))
x = MC{1,NS}(1.0, 1.0)

res = @btime direct_relax(f, x, p)
println(res) # 342.860 μs (2414 allocations: 96.52 KiB) MC{1, NS}(99.8362536820914, 100.40188539116205, [97.9454, 103.135], [0.0], [0.0], true)

res = @btime fast_direct_relax(f, x, p)
println(res) # 2.972 μs (301 allocations: 4.75 KiB) MC{1, NS}(99.8675794497822, 100.37248484959062, [97.9679, 103.101], [0.0], [0.0], true)